package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Grant(grantArn: primitives.Arn, grantName: String, parentArn: primitives.Arn, licenseArn: primitives.Arn, granteePrincipalArn: primitives.Arn, homeRegion: String, grantStatus: GrantStatus, statusReason: scala.Option[String] = None, version: String, grantedOperations: Iterable[AllowedOperation]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.Grant = {
    import Grant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.Grant.builder().grantArn(grantArn: java.lang.String).grantName(grantName: java.lang.String).parentArn(parentArn: java.lang.String).licenseArn(licenseArn: java.lang.String).granteePrincipalArn(granteePrincipalArn: java.lang.String).homeRegion(homeRegion: java.lang.String).grantStatus(grantStatus.unwrap).optionallyWith(statusReason.map(value => value: java.lang.String))(_.statusReason).version(version: java.lang.String).grantedOperationsWithStrings(grantedOperations.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: Grant.ReadOnly = Grant.wrap(buildAwsValue())
}
object Grant {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.Grant] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Grant = Grant(grantArnValue, grantNameValue, parentArnValue, licenseArnValue, granteePrincipalArnValue, homeRegionValue, grantStatusValue, statusReasonValue.map(value => value), versionValue, grantedOperationsValue)
    def grantArnValue: primitives.Arn
    def grantNameValue: String
    def parentArnValue: primitives.Arn
    def licenseArnValue: primitives.Arn
    def granteePrincipalArnValue: primitives.Arn
    def homeRegionValue: String
    def grantStatusValue: GrantStatus
    def statusReasonValue: scala.Option[String]
    def versionValue: String
    def grantedOperationsValue: List[AllowedOperation]
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
    def grantName: ZIO[Any, Nothing, String] = ZIO.succeed(grantNameValue)
    def parentArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(parentArnValue)
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def granteePrincipalArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(granteePrincipalArnValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def grantStatus: ZIO[Any, Nothing, GrantStatus] = ZIO.succeed(grantStatusValue)
    def statusReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusReason", statusReasonValue)
    def version: ZIO[Any, Nothing, String] = ZIO.succeed(versionValue)
    def grantedOperations: ZIO[Any, Nothing, List[AllowedOperation]] = ZIO.succeed(grantedOperationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.Grant) extends Grant.ReadOnly {
    override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn
    override def grantNameValue: String = impl.grantName(): String
    override def parentArnValue: primitives.Arn = impl.parentArn(): primitives.Arn
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def granteePrincipalArnValue: primitives.Arn = impl.granteePrincipalArn(): primitives.Arn
    override def homeRegionValue: String = impl.homeRegion(): String
    override def grantStatusValue: GrantStatus = GrantStatus.wrap(impl.grantStatus())
    override def statusReasonValue: scala.Option[String] = scala.Option(impl.statusReason()).map(value => value: String)
    override def versionValue: String = impl.version(): String
    override def grantedOperationsValue: List[AllowedOperation] = impl.grantedOperations().asScala.map { item => 
      AllowedOperation.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.Grant): ReadOnly = new Wrapper(impl)
}