package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArn: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest = {
    import GetLicenseManagerReportGeneratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest.builder().licenseManagerReportGeneratorArn(licenseManagerReportGeneratorArn: java.lang.String).build()
  }
  def asReadOnly: GetLicenseManagerReportGeneratorRequest.ReadOnly = GetLicenseManagerReportGeneratorRequest.wrap(buildAwsValue())
}
object GetLicenseManagerReportGeneratorRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLicenseManagerReportGeneratorRequest = GetLicenseManagerReportGeneratorRequest(licenseManagerReportGeneratorArnValue)
    def licenseManagerReportGeneratorArnValue: String
    def licenseManagerReportGeneratorArn: ZIO[Any, Nothing, String] = ZIO.succeed(licenseManagerReportGeneratorArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest) extends GetLicenseManagerReportGeneratorRequest.ReadOnly { override def licenseManagerReportGeneratorArnValue: String = impl.licenseManagerReportGeneratorArn(): String }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetLicenseManagerReportGeneratorRequest): ReadOnly = new Wrapper(impl)
}