package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetAccessTokenRequest(token: primitives.TokenString, tokenProperties: scala.Option[Iterable[String]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest = {
    import GetAccessTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest.builder().token(token: java.lang.String).optionallyWith(tokenProperties.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.tokenProperties).build()
  }
  def asReadOnly: GetAccessTokenRequest.ReadOnly = GetAccessTokenRequest.wrap(buildAwsValue())
}
object GetAccessTokenRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetAccessTokenRequest = GetAccessTokenRequest(tokenValue, tokenPropertiesValue.map(value => value))
    def tokenValue: primitives.TokenString
    def tokenPropertiesValue: scala.Option[List[String]]
    def token: ZIO[Any, Nothing, primitives.TokenString] = ZIO.succeed(tokenValue)
    def tokenProperties: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tokenProperties", tokenPropertiesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest) extends GetAccessTokenRequest.ReadOnly {
    override def tokenValue: primitives.TokenString = impl.token(): primitives.TokenString
    override def tokenPropertiesValue: scala.Option[List[String]] = scala.Option(impl.tokenProperties()).map(value => value.asScala.map { item => 
      item: String
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.GetAccessTokenRequest): ReadOnly = new Wrapper(impl)
}