package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExtendLicenseConsumptionResponse(licenseConsumptionToken: scala.Option[String] = None, expiration: scala.Option[primitives.ISO8601DateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse = {
    import ExtendLicenseConsumptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse.builder().optionallyWith(licenseConsumptionToken.map(value => value: java.lang.String))(_.licenseConsumptionToken).optionallyWith(expiration.map(value => value: java.lang.String))(_.expiration).build()
  }
  def asReadOnly: ExtendLicenseConsumptionResponse.ReadOnly = ExtendLicenseConsumptionResponse.wrap(buildAwsValue())
}
object ExtendLicenseConsumptionResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExtendLicenseConsumptionResponse = ExtendLicenseConsumptionResponse(licenseConsumptionTokenValue.map(value => value), expirationValue.map(value => value))
    def licenseConsumptionTokenValue: scala.Option[String]
    def expirationValue: scala.Option[primitives.ISO8601DateTime]
    def licenseConsumptionToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConsumptionToken", licenseConsumptionTokenValue)
    def expiration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiration", expirationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse) extends ExtendLicenseConsumptionResponse.ReadOnly {
    override def licenseConsumptionTokenValue: scala.Option[String] = scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def expirationValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.expiration()).map(value => value: primitives.ISO8601DateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ExtendLicenseConsumptionResponse): ReadOnly = new Wrapper(impl)
}