package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class EntitlementData(name: String, value: scala.Option[String] = None, unit: EntitlementDataUnit) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.EntitlementData = {
    import EntitlementData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.EntitlementData.builder().name(name: java.lang.String).optionallyWith(value.map(value => value: java.lang.String))(_.value).unit(unit.unwrap).build()
  }
  def asReadOnly: EntitlementData.ReadOnly = EntitlementData.wrap(buildAwsValue())
}
object EntitlementData {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.EntitlementData] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: EntitlementData = EntitlementData(nameValue, valueValue.map(value => value), unitValue)
    def nameValue: String
    def valueValue: scala.Option[String]
    def unitValue: EntitlementDataUnit
    def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
    def unit: ZIO[Any, Nothing, EntitlementDataUnit] = ZIO.succeed(unitValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.EntitlementData) extends EntitlementData.ReadOnly {
    override def nameValue: String = impl.name(): String
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
    override def unitValue: EntitlementDataUnit = EntitlementDataUnit.wrap(impl.unit())
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.EntitlementData): ReadOnly = new Wrapper(impl)
}