package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait DigitalSignatureMethod { def unwrap: software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod }
object DigitalSignatureMethod {
  def wrap(value: software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod): DigitalSignatureMethod = value match {
    case software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod.JWT_PS384 =>
      val r = JWT_PS384
      r
  }
  case object unknownToSdkVersion extends DigitalSignatureMethod { override def unwrap: software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod = software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod.UNKNOWN_TO_SDK_VERSION }
  case object JWT_PS384 extends DigitalSignatureMethod { override def unwrap: software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod = software.amazon.awssdk.services.licensemanager.model.DigitalSignatureMethod.JWT_PS384 }
}