package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLicenseRequest(licenseArn: primitives.Arn, sourceVersion: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest = {
    import DeleteLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest.builder().licenseArn(licenseArn: java.lang.String).sourceVersion(sourceVersion: java.lang.String).build()
  }
  def asReadOnly: DeleteLicenseRequest.ReadOnly = DeleteLicenseRequest.wrap(buildAwsValue())
}
object DeleteLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLicenseRequest = DeleteLicenseRequest(licenseArnValue, sourceVersionValue)
    def licenseArnValue: primitives.Arn
    def sourceVersionValue: String
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def sourceVersion: ZIO[Any, Nothing, String] = ZIO.succeed(sourceVersionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest) extends DeleteLicenseRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def sourceVersionValue: String = impl.sourceVersion(): String
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteLicenseRequest): ReadOnly = new Wrapper(impl)
}