package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteGrantRequest(grantArn: primitives.Arn, version: String) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest = {
    import DeleteGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest.builder().grantArn(grantArn: java.lang.String).version(version: java.lang.String).build()
  }
  def asReadOnly: DeleteGrantRequest.ReadOnly = DeleteGrantRequest.wrap(buildAwsValue())
}
object DeleteGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteGrantRequest = DeleteGrantRequest(grantArnValue, versionValue)
    def grantArnValue: primitives.Arn
    def versionValue: String
    def grantArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(grantArnValue)
    def version: ZIO[Any, Nothing, String] = ZIO.succeed(versionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest) extends DeleteGrantRequest.ReadOnly {
    override def grantArnValue: primitives.Arn = impl.grantArn(): primitives.Arn
    override def versionValue: String = impl.version(): String
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.DeleteGrantRequest): ReadOnly = new Wrapper(impl)
}