package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseVersionRequest(licenseArn: primitives.Arn, licenseName: String, productName: String, issuer: Issuer, homeRegion: String, validity: DatetimeRange, licenseMetadata: scala.Option[Iterable[Metadata]] = None, entitlements: Iterable[Entitlement], consumptionConfiguration: ConsumptionConfiguration, status: LicenseStatus, clientToken: String, sourceVersion: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest = {
    import CreateLicenseVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest.builder().licenseArn(licenseArn: java.lang.String).licenseName(licenseName: java.lang.String).productName(productName: java.lang.String).issuer(issuer.buildAwsValue()).homeRegion(homeRegion: java.lang.String).validity(validity.buildAwsValue()).optionallyWith(licenseMetadata.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.licenseMetadata).entitlements(entitlements.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).consumptionConfiguration(consumptionConfiguration.buildAwsValue()).status(status.unwrap).clientToken(clientToken: java.lang.String).optionallyWith(sourceVersion.map(value => value: java.lang.String))(_.sourceVersion).build()
  }
  def asReadOnly: CreateLicenseVersionRequest.ReadOnly = CreateLicenseVersionRequest.wrap(buildAwsValue())
}
object CreateLicenseVersionRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseVersionRequest = CreateLicenseVersionRequest(licenseArnValue, licenseNameValue, productNameValue, issuerValue.editable, homeRegionValue, validityValue.editable, licenseMetadataValue.map(value => value.map { item => 
      item.editable
    }), entitlementsValue.map { item => 
      item.editable
    }, consumptionConfigurationValue.editable, statusValue, clientTokenValue, sourceVersionValue.map(value => value))
    def licenseArnValue: primitives.Arn
    def licenseNameValue: String
    def productNameValue: String
    def issuerValue: Issuer.ReadOnly
    def homeRegionValue: String
    def validityValue: DatetimeRange.ReadOnly
    def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]]
    def entitlementsValue: List[Entitlement.ReadOnly]
    def consumptionConfigurationValue: ConsumptionConfiguration.ReadOnly
    def statusValue: LicenseStatus
    def clientTokenValue: String
    def sourceVersionValue: scala.Option[String]
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def licenseName: ZIO[Any, Nothing, String] = ZIO.succeed(licenseNameValue)
    def productName: ZIO[Any, Nothing, String] = ZIO.succeed(productNameValue)
    def issuer: ZIO[Any, Nothing, Issuer.ReadOnly] = ZIO.succeed(issuerValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def validity: ZIO[Any, Nothing, DatetimeRange.ReadOnly] = ZIO.succeed(validityValue)
    def licenseMetadata: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Metadata.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseMetadata", licenseMetadataValue)
    def entitlements: ZIO[Any, Nothing, List[Entitlement.ReadOnly]] = ZIO.succeed(entitlementsValue)
    def consumptionConfiguration: ZIO[Any, Nothing, ConsumptionConfiguration.ReadOnly] = ZIO.succeed(consumptionConfigurationValue)
    def status: ZIO[Any, Nothing, LicenseStatus] = ZIO.succeed(statusValue)
    def clientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientTokenValue)
    def sourceVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceVersion", sourceVersionValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest) extends CreateLicenseVersionRequest.ReadOnly {
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def licenseNameValue: String = impl.licenseName(): String
    override def productNameValue: String = impl.productName(): String
    override def issuerValue: Issuer.ReadOnly = Issuer.wrap(impl.issuer())
    override def homeRegionValue: String = impl.homeRegion(): String
    override def validityValue: DatetimeRange.ReadOnly = DatetimeRange.wrap(impl.validity())
    override def licenseMetadataValue: scala.Option[List[Metadata.ReadOnly]] = scala.Option(impl.licenseMetadata()).map(value => value.asScala.map { item => 
      Metadata.wrap(item)
    }.toList)
    override def entitlementsValue: List[Entitlement.ReadOnly] = impl.entitlements().asScala.map { item => 
      Entitlement.wrap(item)
    }.toList
    override def consumptionConfigurationValue: ConsumptionConfiguration.ReadOnly = ConsumptionConfiguration.wrap(impl.consumptionConfiguration())
    override def statusValue: LicenseStatus = LicenseStatus.wrap(impl.status())
    override def clientTokenValue: String = impl.clientToken(): String
    override def sourceVersionValue: scala.Option[String] = scala.Option(impl.sourceVersion()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseVersionRequest): ReadOnly = new Wrapper(impl)
}