package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateLicenseManagerReportGeneratorResponse(licenseManagerReportGeneratorArn: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse = {
    import CreateLicenseManagerReportGeneratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse.builder().optionallyWith(licenseManagerReportGeneratorArn.map(value => value: java.lang.String))(_.licenseManagerReportGeneratorArn).build()
  }
  def asReadOnly: CreateLicenseManagerReportGeneratorResponse.ReadOnly = CreateLicenseManagerReportGeneratorResponse.wrap(buildAwsValue())
}
object CreateLicenseManagerReportGeneratorResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateLicenseManagerReportGeneratorResponse = CreateLicenseManagerReportGeneratorResponse(licenseManagerReportGeneratorArnValue.map(value => value))
    def licenseManagerReportGeneratorArnValue: scala.Option[String]
    def licenseManagerReportGeneratorArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseManagerReportGeneratorArn", licenseManagerReportGeneratorArnValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse) extends CreateLicenseManagerReportGeneratorResponse.ReadOnly { override def licenseManagerReportGeneratorArnValue: scala.Option[String] = scala.Option(impl.licenseManagerReportGeneratorArn()).map(value => value: String) }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateLicenseManagerReportGeneratorResponse): ReadOnly = new Wrapper(impl)
}