package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateGrantRequest(clientToken: String, grantName: String, licenseArn: primitives.Arn, principals: Iterable[primitives.Arn], homeRegion: String, allowedOperations: Iterable[AllowedOperation]) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest = {
    import CreateGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest.builder().clientToken(clientToken: java.lang.String).grantName(grantName: java.lang.String).licenseArn(licenseArn: java.lang.String).principals(principals.map { item => 
      item: java.lang.String
    }.asJavaCollection).homeRegion(homeRegion: java.lang.String).allowedOperationsWithStrings(allowedOperations.map { item => 
      item.unwrap.toString
    }.asJavaCollection).build()
  }
  def asReadOnly: CreateGrantRequest.ReadOnly = CreateGrantRequest.wrap(buildAwsValue())
}
object CreateGrantRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateGrantRequest = CreateGrantRequest(clientTokenValue, grantNameValue, licenseArnValue, principalsValue, homeRegionValue, allowedOperationsValue)
    def clientTokenValue: String
    def grantNameValue: String
    def licenseArnValue: primitives.Arn
    def principalsValue: List[primitives.Arn]
    def homeRegionValue: String
    def allowedOperationsValue: List[AllowedOperation]
    def clientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientTokenValue)
    def grantName: ZIO[Any, Nothing, String] = ZIO.succeed(grantNameValue)
    def licenseArn: ZIO[Any, Nothing, primitives.Arn] = ZIO.succeed(licenseArnValue)
    def principals: ZIO[Any, Nothing, List[primitives.Arn]] = ZIO.succeed(principalsValue)
    def homeRegion: ZIO[Any, Nothing, String] = ZIO.succeed(homeRegionValue)
    def allowedOperations: ZIO[Any, Nothing, List[AllowedOperation]] = ZIO.succeed(allowedOperationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest) extends CreateGrantRequest.ReadOnly {
    override def clientTokenValue: String = impl.clientToken(): String
    override def grantNameValue: String = impl.grantName(): String
    override def licenseArnValue: primitives.Arn = impl.licenseArn(): primitives.Arn
    override def principalsValue: List[primitives.Arn] = impl.principals().asScala.map { item => 
      item: primitives.Arn
    }.toList
    override def homeRegionValue: String = impl.homeRegion(): String
    override def allowedOperationsValue: List[AllowedOperation] = impl.allowedOperations().asScala.map { item => 
      AllowedOperation.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CreateGrantRequest): ReadOnly = new Wrapper(impl)
}