package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ConsumptionConfiguration(renewType: scala.Option[RenewType] = None, provisionalConfiguration: scala.Option[ProvisionalConfiguration] = None, borrowConfiguration: scala.Option[BorrowConfiguration] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration = {
    import ConsumptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration.builder().optionallyWith(renewType.map(value => value.unwrap))(_.renewType).optionallyWith(provisionalConfiguration.map(value => value.buildAwsValue()))(_.provisionalConfiguration).optionallyWith(borrowConfiguration.map(value => value.buildAwsValue()))(_.borrowConfiguration).build()
  }
  def asReadOnly: ConsumptionConfiguration.ReadOnly = ConsumptionConfiguration.wrap(buildAwsValue())
}
object ConsumptionConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ConsumptionConfiguration = ConsumptionConfiguration(renewTypeValue.map(value => value), provisionalConfigurationValue.map(value => value.editable), borrowConfigurationValue.map(value => value.editable))
    def renewTypeValue: scala.Option[RenewType]
    def provisionalConfigurationValue: scala.Option[ProvisionalConfiguration.ReadOnly]
    def borrowConfigurationValue: scala.Option[BorrowConfiguration.ReadOnly]
    def renewType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RenewType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("renewType", renewTypeValue)
    def provisionalConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ProvisionalConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("provisionalConfiguration", provisionalConfigurationValue)
    def borrowConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BorrowConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("borrowConfiguration", borrowConfigurationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration) extends ConsumptionConfiguration.ReadOnly {
    override def renewTypeValue: scala.Option[RenewType] = scala.Option(impl.renewType()).map(value => RenewType.wrap(value))
    override def provisionalConfigurationValue: scala.Option[ProvisionalConfiguration.ReadOnly] = scala.Option(impl.provisionalConfiguration()).map(value => ProvisionalConfiguration.wrap(value))
    override def borrowConfigurationValue: scala.Option[BorrowConfiguration.ReadOnly] = scala.Option(impl.borrowConfiguration()).map(value => BorrowConfiguration.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.ConsumptionConfiguration): ReadOnly = new Wrapper(impl)
}