package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CheckoutLicenseResponse(checkoutType: scala.Option[CheckoutType] = None, licenseConsumptionToken: scala.Option[String] = None, entitlementsAllowed: scala.Option[Iterable[EntitlementData]] = None, signedToken: scala.Option[primitives.SignedToken] = None, nodeId: scala.Option[String] = None, issuedAt: scala.Option[primitives.ISO8601DateTime] = None, expiration: scala.Option[primitives.ISO8601DateTime] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse = {
    import CheckoutLicenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse.builder().optionallyWith(checkoutType.map(value => value.unwrap))(_.checkoutType).optionallyWith(licenseConsumptionToken.map(value => value: java.lang.String))(_.licenseConsumptionToken).optionallyWith(entitlementsAllowed.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.entitlementsAllowed).optionallyWith(signedToken.map(value => value: java.lang.String))(_.signedToken).optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId).optionallyWith(issuedAt.map(value => value: java.lang.String))(_.issuedAt).optionallyWith(expiration.map(value => value: java.lang.String))(_.expiration).build()
  }
  def asReadOnly: CheckoutLicenseResponse.ReadOnly = CheckoutLicenseResponse.wrap(buildAwsValue())
}
object CheckoutLicenseResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CheckoutLicenseResponse = CheckoutLicenseResponse(checkoutTypeValue.map(value => value), licenseConsumptionTokenValue.map(value => value), entitlementsAllowedValue.map(value => value.map { item => 
      item.editable
    }), signedTokenValue.map(value => value), nodeIdValue.map(value => value), issuedAtValue.map(value => value), expirationValue.map(value => value))
    def checkoutTypeValue: scala.Option[CheckoutType]
    def licenseConsumptionTokenValue: scala.Option[String]
    def entitlementsAllowedValue: scala.Option[List[EntitlementData.ReadOnly]]
    def signedTokenValue: scala.Option[primitives.SignedToken]
    def nodeIdValue: scala.Option[String]
    def issuedAtValue: scala.Option[primitives.ISO8601DateTime]
    def expirationValue: scala.Option[primitives.ISO8601DateTime]
    def checkoutType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CheckoutType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("checkoutType", checkoutTypeValue)
    def licenseConsumptionToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseConsumptionToken", licenseConsumptionTokenValue)
    def entitlementsAllowed: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EntitlementData.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("entitlementsAllowed", entitlementsAllowedValue)
    def signedToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SignedToken] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("signedToken", signedTokenValue)
    def nodeId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nodeId", nodeIdValue)
    def issuedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("issuedAt", issuedAtValue)
    def expiration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ISO8601DateTime] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiration", expirationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse) extends CheckoutLicenseResponse.ReadOnly {
    override def checkoutTypeValue: scala.Option[CheckoutType] = scala.Option(impl.checkoutType()).map(value => CheckoutType.wrap(value))
    override def licenseConsumptionTokenValue: scala.Option[String] = scala.Option(impl.licenseConsumptionToken()).map(value => value: String)
    override def entitlementsAllowedValue: scala.Option[List[EntitlementData.ReadOnly]] = scala.Option(impl.entitlementsAllowed()).map(value => value.asScala.map { item => 
      EntitlementData.wrap(item)
    }.toList)
    override def signedTokenValue: scala.Option[primitives.SignedToken] = scala.Option(impl.signedToken()).map(value => value: primitives.SignedToken)
    override def nodeIdValue: scala.Option[String] = scala.Option(impl.nodeId()).map(value => value: String)
    override def issuedAtValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.issuedAt()).map(value => value: primitives.ISO8601DateTime)
    override def expirationValue: scala.Option[primitives.ISO8601DateTime] = scala.Option(impl.expiration()).map(value => value: primitives.ISO8601DateTime)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseResponse): ReadOnly = new Wrapper(impl)
}