package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CheckoutLicenseRequest(productSKU: String, checkoutType: CheckoutType, keyFingerprint: String, entitlements: Iterable[EntitlementData], clientToken: primitives.ClientToken, beneficiary: scala.Option[String] = None, nodeId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest = {
    import CheckoutLicenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest.builder().productSKU(productSKU: java.lang.String).checkoutType(checkoutType.unwrap).keyFingerprint(keyFingerprint: java.lang.String).entitlements(entitlements.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).clientToken(clientToken: java.lang.String).optionallyWith(beneficiary.map(value => value: java.lang.String))(_.beneficiary).optionallyWith(nodeId.map(value => value: java.lang.String))(_.nodeId).build()
  }
  def asReadOnly: CheckoutLicenseRequest.ReadOnly = CheckoutLicenseRequest.wrap(buildAwsValue())
}
object CheckoutLicenseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CheckoutLicenseRequest = CheckoutLicenseRequest(productSKUValue, checkoutTypeValue, keyFingerprintValue, entitlementsValue.map { item => 
      item.editable
    }, clientTokenValue, beneficiaryValue.map(value => value), nodeIdValue.map(value => value))
    def productSKUValue: String
    def checkoutTypeValue: CheckoutType
    def keyFingerprintValue: String
    def entitlementsValue: List[EntitlementData.ReadOnly]
    def clientTokenValue: primitives.ClientToken
    def beneficiaryValue: scala.Option[String]
    def nodeIdValue: scala.Option[String]
    def productSKU: ZIO[Any, Nothing, String] = ZIO.succeed(productSKUValue)
    def checkoutType: ZIO[Any, Nothing, CheckoutType] = ZIO.succeed(checkoutTypeValue)
    def keyFingerprint: ZIO[Any, Nothing, String] = ZIO.succeed(keyFingerprintValue)
    def entitlements: ZIO[Any, Nothing, List[EntitlementData.ReadOnly]] = ZIO.succeed(entitlementsValue)
    def clientToken: ZIO[Any, Nothing, primitives.ClientToken] = ZIO.succeed(clientTokenValue)
    def beneficiary: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("beneficiary", beneficiaryValue)
    def nodeId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nodeId", nodeIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest) extends CheckoutLicenseRequest.ReadOnly {
    override def productSKUValue: String = impl.productSKU(): String
    override def checkoutTypeValue: CheckoutType = CheckoutType.wrap(impl.checkoutType())
    override def keyFingerprintValue: String = impl.keyFingerprint(): String
    override def entitlementsValue: List[EntitlementData.ReadOnly] = impl.entitlements().asScala.map { item => 
      EntitlementData.wrap(item)
    }.toList
    override def clientTokenValue: primitives.ClientToken = impl.clientToken(): primitives.ClientToken
    override def beneficiaryValue: scala.Option[String] = scala.Option(impl.beneficiary()).map(value => value: String)
    override def nodeIdValue: scala.Option[String] = scala.Option(impl.nodeId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.CheckoutLicenseRequest): ReadOnly = new Wrapper(impl)
}