package io.github.vigoo.zioaws.licensemanager.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class BorrowConfiguration(allowEarlyCheckIn: primitives.BoxBoolean, maxTimeToLiveInMinutes: primitives.BoxInteger) {
  def buildAwsValue(): software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration = {
    import BorrowConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration.builder().allowEarlyCheckIn(allowEarlyCheckIn: java.lang.Boolean).maxTimeToLiveInMinutes(maxTimeToLiveInMinutes: java.lang.Integer).build()
  }
  def asReadOnly: BorrowConfiguration.ReadOnly = BorrowConfiguration.wrap(buildAwsValue())
}
object BorrowConfiguration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: BorrowConfiguration = BorrowConfiguration(allowEarlyCheckInValue, maxTimeToLiveInMinutesValue)
    def allowEarlyCheckInValue: primitives.BoxBoolean
    def maxTimeToLiveInMinutesValue: primitives.BoxInteger
    def allowEarlyCheckIn: ZIO[Any, Nothing, primitives.BoxBoolean] = ZIO.succeed(allowEarlyCheckInValue)
    def maxTimeToLiveInMinutes: ZIO[Any, Nothing, primitives.BoxInteger] = ZIO.succeed(maxTimeToLiveInMinutesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration) extends BorrowConfiguration.ReadOnly {
    override def allowEarlyCheckInValue: primitives.BoxBoolean = impl.allowEarlyCheckIn(): primitives.BoxBoolean
    override def maxTimeToLiveInMinutesValue: primitives.BoxInteger = impl.maxTimeToLiveInMinutes(): primitives.BoxInteger
  }
  def wrap(impl: software.amazon.awssdk.services.licensemanager.model.BorrowConfiguration): ReadOnly = new Wrapper(impl)
}