package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.grafana.model.DisassociateLicenseResponse.ReadOnly
import software.amazon.awssdk.services.grafana.{
  GrafanaAsyncClientBuilder,
  GrafanaAsyncClient
}
import io.github.vigoo.zioaws.grafana.Grafana
import io.github.vigoo.zioaws.core.{AwsServiceBase, AwsError}
import io.github.vigoo.zioaws.grafana.model.{
  CreateWorkspaceRequest,
  DescribeWorkspaceAuthenticationRequest,
  DeleteWorkspaceRequest,
  ListWorkspacesRequest,
  DescribeWorkspaceRequest,
  AssociateLicenseRequest,
  UpdateWorkspaceAuthenticationRequest,
  UpdatePermissionsRequest,
  ListPermissionsRequest,
  DisassociateLicenseRequest,
  UpdateWorkspaceRequest
}
import software.amazon.awssdk.services.grafana.paginators.{
  ListPermissionsPublisher,
  ListWorkspacesPublisher
}
import software.amazon.awssdk.services.grafana.model.{
  PermissionEntry,
  CreateWorkspaceResponse,
  UpdateWorkspaceAuthenticationResponse,
  DescribeWorkspaceResponse,
  WorkspaceSummary,
  DeleteWorkspaceResponse,
  AssociateLicenseResponse,
  DescribeWorkspaceAuthenticationResponse,
  UpdateWorkspaceResponse,
  UpdatePermissionsResponse,
  DisassociateLicenseResponse
}
import io.github.vigoo.zioaws.core.config.AwsConfig
import zio.{ZManaged, IO, ZIO, ZLayer, URLayer, Has}
import io.github.vigoo.zioaws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.stream.ZStream
import zio.test.mock.{Proxy, Mock}
package object grafana {
  import scala.jdk.CollectionConverters.*
  type Grafana = Has[Grafana.Service]
  object Grafana {
    trait Service extends AspectSupport[Service] {
      val api: GrafanaAsyncClient
      def describeWorkspace(request: DescribeWorkspaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly
      ]
      def disassociateLicense(
          request: DisassociateLicenseRequest
      ): IO[AwsError, ReadOnly]
      def updatePermissions(request: UpdatePermissionsRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly
      ]
      def createWorkspace(request: CreateWorkspaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly
      ]
      def updateWorkspaceAuthentication(
          request: UpdateWorkspaceAuthenticationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
      ]
      def listWorkspaces(request: ListWorkspacesRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
      ]
      def associateLicense(request: AssociateLicenseRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.ReadOnly
      ]
      def listPermissions(request: ListPermissionsRequest): ZStream[
        Any,
        AwsError,
        io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
      ]
      def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly
      ]
      def describeWorkspaceAuthentication(
          request: DescribeWorkspaceAuthenticationRequest
      ): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
      ]
      def updateWorkspace(request: UpdateWorkspaceRequest): IO[
        AwsError,
        io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly
      ]
    }
    object GrafanaMock extends Mock[Grafana] {
      object DescribeWorkspace
          extends Effect[
            DescribeWorkspaceRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly
          ]
      object DisassociateLicense
          extends Effect[DisassociateLicenseRequest, AwsError, ReadOnly]
      object UpdatePermissions
          extends Effect[
            UpdatePermissionsRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly
          ]
      object CreateWorkspace
          extends Effect[
            CreateWorkspaceRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly
          ]
      object UpdateWorkspaceAuthentication
          extends Effect[
            UpdateWorkspaceAuthenticationRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
          ]
      object ListWorkspaces
          extends Stream[
            ListWorkspacesRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
          ]
      object AssociateLicense
          extends Effect[
            AssociateLicenseRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.ReadOnly
          ]
      object ListPermissions
          extends Stream[
            ListPermissionsRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
          ]
      object DeleteWorkspace
          extends Effect[
            DeleteWorkspaceRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly
          ]
      object DescribeWorkspaceAuthentication
          extends Effect[
            DescribeWorkspaceAuthenticationRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
          ]
      object UpdateWorkspace
          extends Effect[
            UpdateWorkspaceRequest,
            AwsError,
            io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly
          ]
      val compose: URLayer[Has[Proxy], Grafana] = ZLayer.fromServiceM { proxy =>
        withRuntime.map { rts =>
          new Grafana.Service {
            val api: GrafanaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: R1
            ): Grafana.Service = this
            def describeWorkspace(request: DescribeWorkspaceRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly
            ] = proxy(DescribeWorkspace, request)
            def disassociateLicense(
                request: DisassociateLicenseRequest
            ): IO[AwsError, ReadOnly] = proxy(DisassociateLicense, request)
            def updatePermissions(request: UpdatePermissionsRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly
            ] = proxy(UpdatePermissions, request)
            def createWorkspace(request: CreateWorkspaceRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly
            ] = proxy(CreateWorkspace, request)
            def updateWorkspaceAuthentication(
                request: UpdateWorkspaceAuthenticationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
            ] = proxy(UpdateWorkspaceAuthentication, request)
            def listWorkspaces(request: ListWorkspacesRequest): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListWorkspaces, request))
            def associateLicense(request: AssociateLicenseRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.ReadOnly
            ] = proxy(AssociateLicense, request)
            def listPermissions(request: ListPermissionsRequest): ZStream[
              Any,
              AwsError,
              io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
            ] = rts.unsafeRun(proxy(ListPermissions, request))
            def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly
            ] = proxy(DeleteWorkspace, request)
            def describeWorkspaceAuthentication(
                request: DescribeWorkspaceAuthenticationRequest
            ): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
            ] = proxy(DescribeWorkspaceAuthentication, request)
            def updateWorkspace(request: UpdateWorkspaceRequest): IO[
              AwsError,
              io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly
            ] = proxy(UpdateWorkspace, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, java.lang.Throwable, Grafana] = customized(
    identity
  )
  def customized(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Grafana] = managed(
    customization
  ).toLayer
  def managed(
      customization: GrafanaAsyncClientBuilder => GrafanaAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Grafana.Service] = for (
    awsConfig <- ZManaged.service[AwsConfig.Service];
    executor <- ZIO.executor.toManaged_;
    builder = GrafanaAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[GrafanaAsyncClient, GrafanaAsyncClientBuilder](builder)
      .toManaged_;
    b1 <- awsConfig
      .configureHttpClient[GrafanaAsyncClient, GrafanaAsyncClientBuilder](
        b0,
        io.github.vigoo.zioaws.core.httpclient
          .ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged_; client <- zio.ZIO(customization(b1).build()).toManaged_
  ) yield new GrafanaImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class GrafanaImpl[R](
      override val api: GrafanaAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: R
  ) extends Grafana.Service
      with AwsServiceBase[R, GrafanaImpl] {
    override val serviceName: String = "Grafana"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: R1
    ): GrafanaImpl[R1] = new GrafanaImpl(api, newAspect, r)
    def describeWorkspace(request: DescribeWorkspaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest,
      DescribeWorkspaceResponse
    ]("describeWorkspace", api.describeWorkspace)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.wrap)
      .provide(r)
    def disassociateLicense(
        request: DisassociateLicenseRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DisassociateLicenseRequest,
      DisassociateLicenseResponse
    ]("disassociateLicense", api.disassociateLicense)(request.buildAwsValue())
      .map(
        io.github.vigoo.zioaws.grafana.model.DisassociateLicenseResponse.wrap
      )
      .provide(r)
    def updatePermissions(request: UpdatePermissionsRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest,
      UpdatePermissionsResponse
    ]("updatePermissions", api.updatePermissions)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.wrap)
      .provide(r)
    def createWorkspace(request: CreateWorkspaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest,
      CreateWorkspaceResponse
    ]("createWorkspace", api.createWorkspace)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.wrap)
      .provide(r)
    def updateWorkspaceAuthentication(
        request: UpdateWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest,
      UpdateWorkspaceAuthenticationResponse
    ]("updateWorkspaceAuthentication", api.updateWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.wrap
    ).provide(r)
    def listWorkspaces(request: ListWorkspacesRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest,
      WorkspaceSummary,
      ListWorkspacesPublisher
    ]("listWorkspaces", api.listWorkspacesPaginator, _.workspaces())(
      request.buildAwsValue()
    ).map(item =>
      io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.wrap(item)
    ).provide(r)
    def associateLicense(request: AssociateLicenseRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.AssociateLicenseRequest,
      AssociateLicenseResponse
    ]("associateLicense", api.associateLicense)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.wrap)
      .provide(r)
    def listPermissions(request: ListPermissionsRequest): ZStream[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.grafana.model.ListPermissionsRequest,
      PermissionEntry,
      ListPermissionsPublisher
    ]("listPermissions", api.listPermissionsPaginator, _.permissions())(
      request.buildAwsValue()
    ).map(item =>
      io.github.vigoo.zioaws.grafana.model.PermissionEntry.wrap(item)
    ).provide(r)
    def deleteWorkspace(request: DeleteWorkspaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest,
      DeleteWorkspaceResponse
    ]("deleteWorkspace", api.deleteWorkspace)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.wrap)
      .provide(r)
    def describeWorkspaceAuthentication(
        request: DescribeWorkspaceAuthenticationRequest
    ): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest,
      DescribeWorkspaceAuthenticationResponse
    ]("describeWorkspaceAuthentication", api.describeWorkspaceAuthentication)(
      request.buildAwsValue()
    ).map(
      io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.wrap
    ).provide(r)
    def updateWorkspace(request: UpdateWorkspaceRequest): IO[
      AwsError,
      io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest,
      UpdateWorkspaceResponse
    ]("updateWorkspace", api.updateWorkspace)(request.buildAwsValue())
      .map(io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.wrap)
      .provide(r)
  }
  def describeWorkspace(request: DescribeWorkspaceRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeWorkspace(request))
  def disassociateLicense(
      request: DisassociateLicenseRequest
  ): ZIO[Grafana, AwsError, ReadOnly] =
    ZIO.accessM(_.get.disassociateLicense(request))
  def updatePermissions(request: UpdatePermissionsRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly
  ] = ZIO.accessM(_.get.updatePermissions(request))
  def createWorkspace(request: CreateWorkspaceRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.createWorkspace(request))
  def updateWorkspaceAuthentication(
      request: UpdateWorkspaceAuthenticationRequest
  ): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateWorkspaceAuthentication(request))
  def listWorkspaces(request: ListWorkspacesRequest): ZStream[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
  ] = ZStream.accessStream(_.get.listWorkspaces(request))
  def associateLicense(request: AssociateLicenseRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.AssociateLicenseResponse.ReadOnly
  ] = ZIO.accessM(_.get.associateLicense(request))
  def listPermissions(request: ListPermissionsRequest): ZStream[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
  ] = ZStream.accessStream(_.get.listPermissions(request))
  def deleteWorkspace(request: DeleteWorkspaceRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.deleteWorkspace(request))
  def describeWorkspaceAuthentication(
      request: DescribeWorkspaceAuthenticationRequest
  ): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly
  ] = ZIO.accessM(_.get.describeWorkspaceAuthentication(request))
  def updateWorkspace(request: UpdateWorkspaceRequest): ZIO[
    Grafana,
    AwsError,
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly
  ] = ZIO.accessM(_.get.updateWorkspace(request))
}
