package io.github.vigoo.zioaws.grafana
import java.time.Instant
import io.github.vigoo.zioaws.grafana.model.primitives.{
  RoleValue,
  OrganizationalUnit,
  AllowedOrganization
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type AllowedOrganization = String
    type AssertionAttribute = String
    type ClientToken = String
    type Description = String
    type Endpoint = String
    type GrafanaVersion = String
    type IamRoleArn = String
    type IdpMetadataUrl = String
    type ListPermissionsRequestMaxResultsInteger = Int
    type ListWorkspacesRequestMaxResultsInteger = Int
    type LoginValidityDuration = Int
    type OrganizationRoleName = String
    type OrganizationalUnit = String
    type PaginationToken = String
    type RoleValue = String
    type SSOClientId = String
    type SsoId = String
    type StackSetName = String
    type Timestamp = Instant
    type UpdateErrorCodeInteger = Int
    type WorkspaceId = String
    type WorkspaceName = String
  }
  type AllowedOrganizations = List[AllowedOrganization]
  type AuthenticationProviders =
    List[io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes]
  type DataSourceTypesList =
    List[io.github.vigoo.zioaws.grafana.model.DataSourceType]
  type NotificationDestinationsList =
    List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
  type OrganizationalUnitList = List[OrganizationalUnit]
  type PermissionEntryList =
    List[io.github.vigoo.zioaws.grafana.model.PermissionEntry]
  type RoleValueList = List[RoleValue]
  type UpdateErrorList = List[io.github.vigoo.zioaws.grafana.model.UpdateError]
  type UpdateInstructionBatch =
    List[io.github.vigoo.zioaws.grafana.model.UpdateInstruction]
  type UserList = List[io.github.vigoo.zioaws.grafana.model.User]
  type WorkspaceList =
    List[io.github.vigoo.zioaws.grafana.model.WorkspaceSummary]
}
