package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  Timestamp,
  WorkspaceName,
  WorkspaceId,
  Description,
  Endpoint,
  GrafanaVersion
}
import scala.jdk.CollectionConverters.*
final case class WorkspaceSummary(
    authentication: io.github.vigoo.zioaws.grafana.model.AuthenticationSummary,
    created: Timestamp,
    description: Option[Description] = None,
    endpoint: Endpoint,
    grafanaVersion: GrafanaVersion,
    id: WorkspaceId,
    modified: Timestamp,
    name: Option[WorkspaceName] = None,
    notificationDestinations: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = None,
    status: io.github.vigoo.zioaws.grafana.model.WorkspaceStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.WorkspaceSummary = {
    import WorkspaceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.WorkspaceSummary
      .builder()
      .authentication(authentication.buildAwsValue())
      .created(created: Instant)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .endpoint(endpoint: java.lang.String)
      .grafanaVersion(grafanaVersion: java.lang.String)
      .id(id: java.lang.String)
      .modified(modified: Instant)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        notificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationDestinationsWithStrings)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.wrap(buildAwsValue())
}
object WorkspaceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.WorkspaceSummary =
      io.github.vigoo.zioaws.grafana.model.WorkspaceSummary(
        authenticationValue.editable,
        createdValue,
        descriptionValue.map(value => value),
        endpointValue,
        grafanaVersionValue,
        idValue,
        modifiedValue,
        nameValue.map(value => value),
        notificationDestinationsValue.map(value => value),
        statusValue
      )
    def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly
    def createdValue: Timestamp
    def descriptionValue: Option[Description]
    def endpointValue: Endpoint
    def grafanaVersionValue: GrafanaVersion
    def idValue: WorkspaceId
    def modifiedValue: Timestamp
    def nameValue: Option[WorkspaceName]
    def notificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ]
    def statusValue: io.github.vigoo.zioaws.grafana.model.WorkspaceStatus
    def authentication: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly
    ] = ZIO.succeed(authenticationValue)
    def created: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdValue)
    def description: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def endpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpointValue)
    def grafanaVersion: ZIO[Any, Nothing, GrafanaVersion] =
      ZIO.succeed(grafanaVersionValue)
    def id: ZIO[Any, Nothing, WorkspaceId] = ZIO.succeed(idValue)
    def modified: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedValue)
    def name: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def notificationDestinations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "notificationDestinations",
      notificationDestinationsValue
    )
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ) extends io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly {
    override def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.AuthenticationSummary
        .wrap(impl.authentication())
    override def createdValue: Timestamp = impl.created(): Timestamp
    override def descriptionValue: Option[Description] =
      scala.Option(impl.description()).map(value => value: Description)
    override def endpointValue: Endpoint = impl.endpoint(): Endpoint
    override def grafanaVersionValue: GrafanaVersion =
      impl.grafanaVersion(): GrafanaVersion
    override def idValue: WorkspaceId = impl.id(): WorkspaceId
    override def modifiedValue: Timestamp = impl.modified(): Timestamp
    override def nameValue: Option[WorkspaceName] =
      scala.Option(impl.name()).map(value => value: WorkspaceName)
    override def notificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = scala
      .Option(impl.notificationDestinations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
            .wrap(item)
        }.toList
      )
    override def statusValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceStatus =
      io.github.vigoo.zioaws.grafana.model.WorkspaceStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceSummary
  ): io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly =
    new Wrapper(impl)
}
