package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  Timestamp,
  WorkspaceName,
  WorkspaceId,
  Description,
  Endpoint,
  GrafanaVersion
}
import scala.jdk.CollectionConverters.*
final case class WorkspaceDescription(
    accountAccessType: Option[
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
    ] = None,
    authentication: io.github.vigoo.zioaws.grafana.model.AuthenticationSummary,
    created: Timestamp,
    dataSources: Iterable[io.github.vigoo.zioaws.grafana.model.DataSourceType],
    description: Option[Description] = None,
    endpoint: Endpoint,
    freeTrialConsumed: Option[Boolean] = None,
    freeTrialExpiration: Option[Timestamp] = None,
    grafanaVersion: GrafanaVersion,
    id: WorkspaceId,
    licenseExpiration: Option[Timestamp] = None,
    licenseType: Option[io.github.vigoo.zioaws.grafana.model.LicenseType] =
      None,
    modified: Timestamp,
    name: Option[WorkspaceName] = None,
    notificationDestinations: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    organizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    permissionType: Option[
      io.github.vigoo.zioaws.grafana.model.PermissionType
    ] = None,
    stackSetName: Option[StackSetName] = None,
    status: io.github.vigoo.zioaws.grafana.model.WorkspaceStatus,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.WorkspaceDescription = {
    import WorkspaceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .authentication(authentication.buildAwsValue())
      .created(created: Instant)
      .dataSourcesWithStrings(dataSources.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .endpoint(endpoint: java.lang.String)
      .optionallyWith(freeTrialConsumed.map(value => value: java.lang.Boolean))(
        _.freeTrialConsumed
      )
      .optionallyWith(freeTrialExpiration.map(value => value: Instant))(
        _.freeTrialExpiration
      )
      .grafanaVersion(grafanaVersion: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(licenseExpiration.map(value => value: Instant))(
        _.licenseExpiration
      )
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .modified(modified: Instant)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        notificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.notificationDestinationsWithStrings)
      .optionallyWith(
        organizationRoleName.map(value => value: java.lang.String)
      )(_.organizationRoleName)
      .optionallyWith(
        organizationalUnits.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnits)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(stackSetName.map(value => value: java.lang.String))(
        _.stackSetName
      )
      .status(status.unwrap)
      .optionallyWith(workspaceRoleArn.map(value => value: java.lang.String))(
        _.workspaceRoleArn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
      .wrap(buildAwsValue())
}
object WorkspaceDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.WorkspaceDescription =
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription(
        accountAccessTypeValue.map(value => value),
        authenticationValue.editable,
        createdValue,
        dataSourcesValue,
        descriptionValue.map(value => value),
        endpointValue,
        freeTrialConsumedValue.map(value => value),
        freeTrialExpirationValue.map(value => value),
        grafanaVersionValue,
        idValue,
        licenseExpirationValue.map(value => value),
        licenseTypeValue.map(value => value),
        modifiedValue,
        nameValue.map(value => value),
        notificationDestinationsValue.map(value => value),
        organizationRoleNameValue.map(value => value),
        organizationalUnitsValue.map(value => value),
        permissionTypeValue.map(value => value),
        stackSetNameValue.map(value => value),
        statusValue,
        workspaceRoleArnValue.map(value => value)
      )
    def accountAccessTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.AccountAccessType]
    def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly
    def createdValue: Timestamp
    def dataSourcesValue
        : List[io.github.vigoo.zioaws.grafana.model.DataSourceType]
    def descriptionValue: Option[Description]
    def endpointValue: Endpoint
    def freeTrialConsumedValue: Option[Boolean]
    def freeTrialExpirationValue: Option[Timestamp]
    def grafanaVersionValue: GrafanaVersion
    def idValue: WorkspaceId
    def licenseExpirationValue: Option[Timestamp]
    def licenseTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.LicenseType]
    def modifiedValue: Timestamp
    def nameValue: Option[WorkspaceName]
    def notificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ]
    def organizationRoleNameValue: Option[OrganizationRoleName]
    def organizationalUnitsValue: Option[List[OrganizationalUnit]]
    def permissionTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.PermissionType]
    def stackSetNameValue: Option[StackSetName]
    def statusValue: io.github.vigoo.zioaws.grafana.model.WorkspaceStatus
    def workspaceRoleArnValue: Option[IamRoleArn]
    def accountAccessType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
    ] = AwsError.unwrapOptionField("accountAccessType", accountAccessTypeValue)
    def authentication: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly
    ] = ZIO.succeed(authenticationValue)
    def created: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdValue)
    def dataSources: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.DataSourceType
    ]] = ZIO.succeed(dataSourcesValue)
    def description: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", descriptionValue)
    def endpoint: ZIO[Any, Nothing, Endpoint] = ZIO.succeed(endpointValue)
    def freeTrialConsumed: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("freeTrialConsumed", freeTrialConsumedValue)
    def freeTrialExpiration: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("freeTrialExpiration", freeTrialExpirationValue)
    def grafanaVersion: ZIO[Any, Nothing, GrafanaVersion] =
      ZIO.succeed(grafanaVersionValue)
    def id: ZIO[Any, Nothing, WorkspaceId] = ZIO.succeed(idValue)
    def licenseExpiration: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("licenseExpiration", licenseExpirationValue)
    def licenseType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.grafana.model.LicenseType] =
      AwsError.unwrapOptionField("licenseType", licenseTypeValue)
    def modified: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(modifiedValue)
    def name: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("name", nameValue)
    def notificationDestinations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "notificationDestinations",
      notificationDestinationsValue
    )
    def organizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField(
        "organizationRoleName",
        organizationRoleNameValue
      )
    def organizationalUnits: ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "organizationalUnits",
        organizationalUnitsValue
      )
    def permissionType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.PermissionType
    ] = AwsError.unwrapOptionField("permissionType", permissionTypeValue)
    def stackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetNameValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceStatus
    ] = ZIO.succeed(statusValue)
    def workspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ) extends io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly {
    override def accountAccessTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.AccountAccessType] = scala
      .Option(impl.accountAccessType())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.AccountAccessType.wrap(value)
      )
    override def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationSummary.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.AuthenticationSummary
        .wrap(impl.authentication())
    override def createdValue: Timestamp = impl.created(): Timestamp
    override def dataSourcesValue
        : List[io.github.vigoo.zioaws.grafana.model.DataSourceType] = impl
      .dataSources()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.DataSourceType.wrap(item)
      }
      .toList
    override def descriptionValue: Option[Description] =
      scala.Option(impl.description()).map(value => value: Description)
    override def endpointValue: Endpoint = impl.endpoint(): Endpoint
    override def freeTrialConsumedValue: Option[Boolean] =
      scala.Option(impl.freeTrialConsumed()).map(value => value: Boolean)
    override def freeTrialExpirationValue: Option[Timestamp] =
      scala.Option(impl.freeTrialExpiration()).map(value => value: Timestamp)
    override def grafanaVersionValue: GrafanaVersion =
      impl.grafanaVersion(): GrafanaVersion
    override def idValue: WorkspaceId = impl.id(): WorkspaceId
    override def licenseExpirationValue: Option[Timestamp] =
      scala.Option(impl.licenseExpiration()).map(value => value: Timestamp)
    override def licenseTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.LicenseType] = scala
      .Option(impl.licenseType())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.LicenseType.wrap(value)
      )
    override def modifiedValue: Timestamp = impl.modified(): Timestamp
    override def nameValue: Option[WorkspaceName] =
      scala.Option(impl.name()).map(value => value: WorkspaceName)
    override def notificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = scala
      .Option(impl.notificationDestinations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
            .wrap(item)
        }.toList
      )
    override def organizationRoleNameValue: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value => value: OrganizationRoleName)
    override def organizationalUnitsValue: Option[List[OrganizationalUnit]] =
      scala
        .Option(impl.organizationalUnits())
        .map(value =>
          value.asScala.map { item =>
            item: OrganizationalUnit
          }.toList
        )
    override def permissionTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.PermissionType] = scala
      .Option(impl.permissionType())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.PermissionType.wrap(value)
      )
    override def stackSetNameValue: Option[StackSetName] =
      scala.Option(impl.stackSetName()).map(value => value: StackSetName)
    override def statusValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceStatus =
      io.github.vigoo.zioaws.grafana.model.WorkspaceStatus.wrap(impl.status())
    override def workspaceRoleArnValue: Option[IamRoleArn] =
      scala.Option(impl.workspaceRoleArn()).map(value => value: IamRoleArn)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.WorkspaceDescription
  ): io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
    new Wrapper(impl)
}
