package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionsRequest(
    updateInstructionBatch: Iterable[
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction
    ],
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest = {
    import UpdatePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
      .builder()
      .updateInstructionBatch(updateInstructionBatch.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest
      .wrap(buildAwsValue())
}
object UpdatePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest =
      io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest(
        updateInstructionBatchValue.map { item =>
          item.editable
        },
        workspaceIdValue
      )
    def updateInstructionBatchValue
        : List[io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly]
    def workspaceIdValue: WorkspaceId
    def updateInstructionBatch: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly
    ]] = ZIO.succeed(updateInstructionBatchValue)
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ) extends io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest.ReadOnly {
    override def updateInstructionBatchValue: List[
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly
    ] = impl
      .updateInstructionBatch()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.UpdateInstruction.wrap(item)
      }
      .toList
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsRequest
  ): io.github.vigoo.zioaws.grafana.model.UpdatePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
