package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateInstruction(
    action: io.github.vigoo.zioaws.grafana.model.UpdateAction,
    role: io.github.vigoo.zioaws.grafana.model.Role,
    users: Iterable[io.github.vigoo.zioaws.grafana.model.User]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateInstruction = {
    import UpdateInstruction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateInstruction
      .builder()
      .action(action.unwrap)
      .role(role.unwrap)
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateInstruction.wrap(buildAwsValue())
}
object UpdateInstruction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.UpdateInstruction =
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction(
        actionValue,
        roleValue,
        usersValue.map { item =>
          item.editable
        }
      )
    def actionValue: io.github.vigoo.zioaws.grafana.model.UpdateAction
    def roleValue: io.github.vigoo.zioaws.grafana.model.Role
    def usersValue: List[io.github.vigoo.zioaws.grafana.model.User.ReadOnly]
    def action
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.grafana.model.UpdateAction] =
      ZIO.succeed(actionValue)
    def role: ZIO[Any, Nothing, io.github.vigoo.zioaws.grafana.model.Role] =
      ZIO.succeed(roleValue)
    def users: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.User.ReadOnly
    ]] = ZIO.succeed(usersValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly {
    override def actionValue
        : io.github.vigoo.zioaws.grafana.model.UpdateAction =
      io.github.vigoo.zioaws.grafana.model.UpdateAction.wrap(impl.action())
    override def roleValue: io.github.vigoo.zioaws.grafana.model.Role =
      io.github.vigoo.zioaws.grafana.model.Role.wrap(impl.role())
    override def usersValue
        : List[io.github.vigoo.zioaws.grafana.model.User.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.User.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateInstruction
  ): io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly =
    new Wrapper(impl)
}
