package io.github.vigoo.zioaws.grafana.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.UpdateErrorCodeInteger
import scala.jdk.CollectionConverters.*
final case class UpdateError(
    causedBy: io.github.vigoo.zioaws.grafana.model.UpdateInstruction,
    code: UpdateErrorCodeInteger,
    message: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateError = {
    import UpdateError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateError
      .builder()
      .causedBy(causedBy.buildAwsValue())
      .code(code: Integer)
      .message(message: java.lang.String)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateError.wrap(buildAwsValue())
}
object UpdateError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.UpdateError =
      io.github.vigoo.zioaws.grafana.model
        .UpdateError(causedByValue.editable, codeValue, messageValue)
    def causedByValue
        : io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly
    def codeValue: UpdateErrorCodeInteger
    def messageValue: String
    def causedBy: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly
    ] = ZIO.succeed(causedByValue)
    def code: ZIO[Any, Nothing, UpdateErrorCodeInteger] = ZIO.succeed(codeValue)
    def message: ZIO[Any, Nothing, String] = ZIO.succeed(messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateError
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly {
    override def causedByValue
        : io.github.vigoo.zioaws.grafana.model.UpdateInstruction.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.UpdateInstruction
        .wrap(impl.causedBy())
    override def codeValue: UpdateErrorCodeInteger =
      impl.code(): UpdateErrorCodeInteger
    override def messageValue: String = impl.message(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateError
  ): io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly = new Wrapper(
    impl
  )
}
