package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait SamlConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus
}
object SamlConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus
  ): io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus =
    value match {
      case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.CONFIGURED =>
        val r = CONFIGURED
        r
      case software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.NOT_CONFIGURED =>
        val r = NOT_CONFIGURED
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CONFIGURED
      extends io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.CONFIGURED
  }
  case object NOT_CONFIGURED
      extends io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus =
      software.amazon.awssdk.services.grafana.model.SamlConfigurationStatus.NOT_CONFIGURED
  }
}
