package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.RoleValue
import scala.jdk.CollectionConverters.*
final case class RoleValues(
    admin: Option[Iterable[RoleValue]] = None,
    editor: Option[Iterable[RoleValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.RoleValues = {
    import RoleValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.RoleValues
      .builder()
      .optionallyWith(
        admin.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.admin)
      .optionallyWith(
        editor.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.editor)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.RoleValues.wrap(buildAwsValue())
}
object RoleValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.RoleValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.RoleValues =
      io.github.vigoo.zioaws.grafana.model.RoleValues(
        adminValue.map(value => value),
        editorValue.map(value => value)
      )
    def adminValue: Option[List[RoleValue]]
    def editorValue: Option[List[RoleValue]]
    def admin: ZIO[Any, AwsError, List[RoleValue]] =
      AwsError.unwrapOptionField("admin", adminValue)
    def editor: ZIO[Any, AwsError, List[RoleValue]] =
      AwsError.unwrapOptionField("editor", editorValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.RoleValues
  ) extends io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly {
    override def adminValue: Option[List[RoleValue]] = scala
      .Option(impl.admin())
      .map(value =>
        value.asScala.map { item =>
          item: RoleValue
        }.toList
      )
    override def editorValue: Option[List[RoleValue]] = scala
      .Option(impl.editor())
      .map(value =>
        value.asScala.map { item =>
          item: RoleValue
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.RoleValues
  ): io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly = new Wrapper(
    impl
  )
}
