package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait Role {
  def unwrap: software.amazon.awssdk.services.grafana.model.Role
}
object Role {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.Role
  ): io.github.vigoo.zioaws.grafana.model.Role = value match {
    case software.amazon.awssdk.services.grafana.model.Role.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.Role.ADMIN =>
      val r = ADMIN
      r
    case software.amazon.awssdk.services.grafana.model.Role.EDITOR =>
      val r = EDITOR
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.UNKNOWN_TO_SDK_VERSION
  }
  case object ADMIN extends io.github.vigoo.zioaws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.ADMIN
  }
  case object EDITOR extends io.github.vigoo.zioaws.grafana.model.Role {
    override def unwrap: software.amazon.awssdk.services.grafana.model.Role =
      software.amazon.awssdk.services.grafana.model.Role.EDITOR
  }
}
