package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.IdpMetadataUrl
import scala.jdk.CollectionConverters.*
final case class IdpMetadata(
    url: Option[IdpMetadataUrl] = None,
    xml: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.IdpMetadata = {
    import IdpMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.IdpMetadata
      .builder()
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(xml.map(value => value: java.lang.String))(_.xml)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.IdpMetadata.wrap(buildAwsValue())
}
object IdpMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.IdpMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.IdpMetadata =
      io.github.vigoo.zioaws.grafana.model
        .IdpMetadata(urlValue.map(value => value), xmlValue.map(value => value))
    def urlValue: Option[IdpMetadataUrl]
    def xmlValue: Option[String]
    def url: ZIO[Any, AwsError, IdpMetadataUrl] =
      AwsError.unwrapOptionField("url", urlValue)
    def xml: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("xml", xmlValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.IdpMetadata
  ) extends io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly {
    override def urlValue: Option[IdpMetadataUrl] =
      scala.Option(impl.url()).map(value => value: IdpMetadataUrl)
    override def xmlValue: Option[String] =
      scala.Option(impl.xml()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.IdpMetadata
  ): io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly = new Wrapper(
    impl
  )
}
