package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteWorkspaceResponse(
    workspace: io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse = {
    import DeleteWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse
      .wrap(buildAwsValue())
}
object DeleteWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse =
      io.github.vigoo.zioaws.grafana.model
        .DeleteWorkspaceResponse(workspaceValue.editable)
    def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    def workspace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ) extends io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly {
    override def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
        .wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceResponse
  ): io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceResponse.ReadOnly =
    new Wrapper(impl)
}
