package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class DeleteWorkspaceRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest = {
    import DeleteWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
      .builder()
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceRequest
      .wrap(buildAwsValue())
}
object DeleteWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceRequest =
      io.github.vigoo.zioaws.grafana.model
        .DeleteWorkspaceRequest(workspaceIdValue)
    def workspaceIdValue: WorkspaceId
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ) extends io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceRequest.ReadOnly {
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DeleteWorkspaceRequest
  ): io.github.vigoo.zioaws.grafana.model.DeleteWorkspaceRequest.ReadOnly =
    new Wrapper(impl)
}
