package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceResponse(
    workspace: io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse = {
    import CreateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse
      .wrap(buildAwsValue())
}
object CreateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse =
      io.github.vigoo.zioaws.grafana.model
        .CreateWorkspaceResponse(workspaceValue.editable)
    def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    def workspace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ) extends io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly {
    override def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
        .wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceResponse
  ): io.github.vigoo.zioaws.grafana.model.CreateWorkspaceResponse.ReadOnly =
    new Wrapper(impl)
}
