package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  WorkspaceName,
  Description,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class CreateWorkspaceRequest(
    accountAccessType: io.github.vigoo.zioaws.grafana.model.AccountAccessType,
    authenticationProviders: Iterable[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ],
    clientToken: Option[ClientToken] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    permissionType: io.github.vigoo.zioaws.grafana.model.PermissionType,
    stackSetName: Option[StackSetName] = None,
    workspaceDataSources: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.DataSourceType]
    ] = None,
    workspaceDescription: Option[Description] = None,
    workspaceName: Option[WorkspaceName] = None,
    workspaceNotificationDestinations: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = None,
    workspaceOrganizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest = {
    import CreateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
      .builder()
      .accountAccessType(accountAccessType.unwrap)
      .authenticationProvidersWithStrings(authenticationProviders.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        organizationRoleName.map(value => value: java.lang.String)
      )(_.organizationRoleName)
      .permissionType(permissionType.unwrap)
      .optionallyWith(stackSetName.map(value => value: java.lang.String))(
        _.stackSetName
      )
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value => value: java.lang.String)
      )(_.workspaceDescription)
      .optionallyWith(workspaceName.map(value => value: java.lang.String))(
        _.workspaceName
      )
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(workspaceRoleArn.map(value => value: java.lang.String))(
        _.workspaceRoleArn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest
      .wrap(buildAwsValue())
}
object CreateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest =
      io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest(
        accountAccessTypeValue,
        authenticationProvidersValue,
        clientTokenValue.map(value => value),
        organizationRoleNameValue.map(value => value),
        permissionTypeValue,
        stackSetNameValue.map(value => value),
        workspaceDataSourcesValue.map(value => value),
        workspaceDescriptionValue.map(value => value),
        workspaceNameValue.map(value => value),
        workspaceNotificationDestinationsValue.map(value => value),
        workspaceOrganizationalUnitsValue.map(value => value),
        workspaceRoleArnValue.map(value => value)
      )
    def accountAccessTypeValue
        : io.github.vigoo.zioaws.grafana.model.AccountAccessType
    def authenticationProvidersValue
        : List[io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes]
    def clientTokenValue: Option[ClientToken]
    def organizationRoleNameValue: Option[OrganizationRoleName]
    def permissionTypeValue: io.github.vigoo.zioaws.grafana.model.PermissionType
    def stackSetNameValue: Option[StackSetName]
    def workspaceDataSourcesValue
        : Option[List[io.github.vigoo.zioaws.grafana.model.DataSourceType]]
    def workspaceDescriptionValue: Option[Description]
    def workspaceNameValue: Option[WorkspaceName]
    def workspaceNotificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ]
    def workspaceOrganizationalUnitsValue: Option[List[OrganizationalUnit]]
    def workspaceRoleArnValue: Option[IamRoleArn]
    def accountAccessType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
    ] = ZIO.succeed(accountAccessTypeValue)
    def authenticationProviders: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(authenticationProvidersValue)
    def clientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientTokenValue)
    def organizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField(
        "organizationRoleName",
        organizationRoleNameValue
      )
    def permissionType: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.PermissionType
    ] = ZIO.succeed(permissionTypeValue)
    def stackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetNameValue)
    def workspaceDataSources: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.DataSourceType
    ]] = AwsError.unwrapOptionField(
      "workspaceDataSources",
      workspaceDataSourcesValue
    )
    def workspaceDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("workspaceDescription", workspaceDescriptionValue)
    def workspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceNameValue)
    def workspaceNotificationDestinations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinationsValue
    )
    def workspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnitsValue
      )
    def workspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ) extends io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest.ReadOnly {
    override def accountAccessTypeValue
        : io.github.vigoo.zioaws.grafana.model.AccountAccessType =
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
        .wrap(impl.accountAccessType())
    override def authenticationProvidersValue: List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ] = impl
      .authenticationProviders()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
          .wrap(item)
      }
      .toList
    override def clientTokenValue: Option[ClientToken] =
      scala.Option(impl.clientToken()).map(value => value: ClientToken)
    override def organizationRoleNameValue: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value => value: OrganizationRoleName)
    override def permissionTypeValue
        : io.github.vigoo.zioaws.grafana.model.PermissionType =
      io.github.vigoo.zioaws.grafana.model.PermissionType
        .wrap(impl.permissionType())
    override def stackSetNameValue: Option[StackSetName] =
      scala.Option(impl.stackSetName()).map(value => value: StackSetName)
    override def workspaceDataSourcesValue
        : Option[List[io.github.vigoo.zioaws.grafana.model.DataSourceType]] =
      scala
        .Option(impl.workspaceDataSources())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.grafana.model.DataSourceType.wrap(item)
          }.toList
        )
    override def workspaceDescriptionValue: Option[Description] =
      scala.Option(impl.workspaceDescription()).map(value => value: Description)
    override def workspaceNameValue: Option[WorkspaceName] =
      scala.Option(impl.workspaceName()).map(value => value: WorkspaceName)
    override def workspaceNotificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = scala
      .Option(impl.workspaceNotificationDestinations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
            .wrap(item)
        }.toList
      )
    override def workspaceOrganizationalUnitsValue
        : Option[List[OrganizationalUnit]] = scala
      .Option(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          item: OrganizationalUnit
        }.toList
      )
    override def workspaceRoleArnValue: Option[IamRoleArn] =
      scala.Option(impl.workspaceRoleArn()).map(value => value: IamRoleArn)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.CreateWorkspaceRequest
  ): io.github.vigoo.zioaws.grafana.model.CreateWorkspaceRequest.ReadOnly =
    new Wrapper(impl)
}
