package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait AuthenticationProviderTypes {
  def unwrap: software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes
}
object AuthenticationProviderTypes {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes
  ): io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes =
    value match {
      case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.AWS_SSO =>
        val r = AWS_SSO
        r
      case software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.SAML =>
        val r = SAML
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_SSO
      extends io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.AWS_SSO
  }
  case object SAML
      extends io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes =
      software.amazon.awssdk.services.grafana.model.AuthenticationProviderTypes.SAML
  }
}
