package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.grafana.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.UserType
  ): io.github.vigoo.zioaws.grafana.model.UserType = value match {
    case software.amazon.awssdk.services.grafana.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.UserType.SSO_USER =>
      val r = SSO_USER
      r
    case software.amazon.awssdk.services.grafana.model.UserType.SSO_GROUP =>
      val r = SSO_GROUP
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UserType =
      software.amazon.awssdk.services.grafana.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object SSO_USER extends io.github.vigoo.zioaws.grafana.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UserType =
      software.amazon.awssdk.services.grafana.model.UserType.SSO_USER
  }
  case object SSO_GROUP extends io.github.vigoo.zioaws.grafana.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UserType =
      software.amazon.awssdk.services.grafana.model.UserType.SSO_GROUP
  }
}
