package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.SsoId
import scala.jdk.CollectionConverters.*
final case class User(
    id: SsoId,
    `type`: io.github.vigoo.zioaws.grafana.model.UserType
) {
  def buildAwsValue(): software.amazon.awssdk.services.grafana.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.User
      .builder()
      .id(id: java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.grafana.model.User.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.grafana.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.User =
      io.github.vigoo.zioaws.grafana.model.User(idValue, typeValue)
    def idValue: SsoId
    def typeValue: io.github.vigoo.zioaws.grafana.model.UserType
    def id: ZIO[Any, Nothing, SsoId] = ZIO.succeed(idValue)
    def `type`
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.grafana.model.UserType] =
      ZIO.succeed(typeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.User
  ) extends io.github.vigoo.zioaws.grafana.model.User.ReadOnly {
    override def idValue: SsoId = impl.id(): SsoId
    override def typeValue: io.github.vigoo.zioaws.grafana.model.UserType =
      io.github.vigoo.zioaws.grafana.model.UserType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.User
  ): io.github.vigoo.zioaws.grafana.model.User.ReadOnly = new Wrapper(impl)
}
