package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceResponse(
    workspace: io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse = {
    import UpdateWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse
      .wrap(buildAwsValue())
}
object UpdateWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse =
      io.github.vigoo.zioaws.grafana.model
        .UpdateWorkspaceResponse(workspaceValue.editable)
    def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    def workspace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly {
    override def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
        .wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceResponse
  ): io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceResponse.ReadOnly =
    new Wrapper(impl)
}
