package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  IamRoleArn,
  OrganizationRoleName,
  OrganizationalUnit,
  StackSetName,
  WorkspaceName,
  WorkspaceId,
  Description
}
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceRequest(
    accountAccessType: Option[
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
    ] = None,
    organizationRoleName: Option[OrganizationRoleName] = None,
    permissionType: Option[
      io.github.vigoo.zioaws.grafana.model.PermissionType
    ] = None,
    stackSetName: Option[StackSetName] = None,
    workspaceDataSources: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.DataSourceType]
    ] = None,
    workspaceDescription: Option[Description] = None,
    workspaceId: WorkspaceId,
    workspaceName: Option[WorkspaceName] = None,
    workspaceNotificationDestinations: Option[
      Iterable[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = None,
    workspaceOrganizationalUnits: Option[Iterable[OrganizationalUnit]] = None,
    workspaceRoleArn: Option[IamRoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest = {
    import UpdateWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
      .builder()
      .optionallyWith(accountAccessType.map(value => value.unwrap))(
        _.accountAccessType
      )
      .optionallyWith(
        organizationRoleName.map(value => value: java.lang.String)
      )(_.organizationRoleName)
      .optionallyWith(permissionType.map(value => value.unwrap))(
        _.permissionType
      )
      .optionallyWith(stackSetName.map(value => value: java.lang.String))(
        _.stackSetName
      )
      .optionallyWith(
        workspaceDataSources.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceDataSourcesWithStrings)
      .optionallyWith(
        workspaceDescription.map(value => value: java.lang.String)
      )(_.workspaceDescription)
      .workspaceId(workspaceId: java.lang.String)
      .optionallyWith(workspaceName.map(value => value: java.lang.String))(
        _.workspaceName
      )
      .optionallyWith(
        workspaceNotificationDestinations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.workspaceNotificationDestinationsWithStrings)
      .optionallyWith(
        workspaceOrganizationalUnits.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.workspaceOrganizationalUnits)
      .optionallyWith(workspaceRoleArn.map(value => value: java.lang.String))(
        _.workspaceRoleArn
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest =
      io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest(
        accountAccessTypeValue.map(value => value),
        organizationRoleNameValue.map(value => value),
        permissionTypeValue.map(value => value),
        stackSetNameValue.map(value => value),
        workspaceDataSourcesValue.map(value => value),
        workspaceDescriptionValue.map(value => value),
        workspaceIdValue,
        workspaceNameValue.map(value => value),
        workspaceNotificationDestinationsValue.map(value => value),
        workspaceOrganizationalUnitsValue.map(value => value),
        workspaceRoleArnValue.map(value => value)
      )
    def accountAccessTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.AccountAccessType]
    def organizationRoleNameValue: Option[OrganizationRoleName]
    def permissionTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.PermissionType]
    def stackSetNameValue: Option[StackSetName]
    def workspaceDataSourcesValue
        : Option[List[io.github.vigoo.zioaws.grafana.model.DataSourceType]]
    def workspaceDescriptionValue: Option[Description]
    def workspaceIdValue: WorkspaceId
    def workspaceNameValue: Option[WorkspaceName]
    def workspaceNotificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ]
    def workspaceOrganizationalUnitsValue: Option[List[OrganizationalUnit]]
    def workspaceRoleArnValue: Option[IamRoleArn]
    def accountAccessType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.AccountAccessType
    ] = AwsError.unwrapOptionField("accountAccessType", accountAccessTypeValue)
    def organizationRoleName: ZIO[Any, AwsError, OrganizationRoleName] =
      AwsError.unwrapOptionField(
        "organizationRoleName",
        organizationRoleNameValue
      )
    def permissionType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.PermissionType
    ] = AwsError.unwrapOptionField("permissionType", permissionTypeValue)
    def stackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetNameValue)
    def workspaceDataSources: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.DataSourceType
    ]] = AwsError.unwrapOptionField(
      "workspaceDataSources",
      workspaceDataSourcesValue
    )
    def workspaceDescription: ZIO[Any, AwsError, Description] = AwsError
      .unwrapOptionField("workspaceDescription", workspaceDescriptionValue)
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
    def workspaceName: ZIO[Any, AwsError, WorkspaceName] =
      AwsError.unwrapOptionField("workspaceName", workspaceNameValue)
    def workspaceNotificationDestinations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
    ]] = AwsError.unwrapOptionField(
      "workspaceNotificationDestinations",
      workspaceNotificationDestinationsValue
    )
    def workspaceOrganizationalUnits
        : ZIO[Any, AwsError, List[OrganizationalUnit]] =
      AwsError.unwrapOptionField(
        "workspaceOrganizationalUnits",
        workspaceOrganizationalUnitsValue
      )
    def workspaceRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("workspaceRoleArn", workspaceRoleArnValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest.ReadOnly {
    override def accountAccessTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.AccountAccessType] = scala
      .Option(impl.accountAccessType())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.AccountAccessType.wrap(value)
      )
    override def organizationRoleNameValue: Option[OrganizationRoleName] = scala
      .Option(impl.organizationRoleName())
      .map(value => value: OrganizationRoleName)
    override def permissionTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.PermissionType] = scala
      .Option(impl.permissionType())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.PermissionType.wrap(value)
      )
    override def stackSetNameValue: Option[StackSetName] =
      scala.Option(impl.stackSetName()).map(value => value: StackSetName)
    override def workspaceDataSourcesValue
        : Option[List[io.github.vigoo.zioaws.grafana.model.DataSourceType]] =
      scala
        .Option(impl.workspaceDataSources())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.grafana.model.DataSourceType.wrap(item)
          }.toList
        )
    override def workspaceDescriptionValue: Option[Description] =
      scala.Option(impl.workspaceDescription()).map(value => value: Description)
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
    override def workspaceNameValue: Option[WorkspaceName] =
      scala.Option(impl.workspaceName()).map(value => value: WorkspaceName)
    override def workspaceNotificationDestinationsValue: Option[
      List[io.github.vigoo.zioaws.grafana.model.NotificationDestinationType]
    ] = scala
      .Option(impl.workspaceNotificationDestinations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.grafana.model.NotificationDestinationType
            .wrap(item)
        }.toList
      )
    override def workspaceOrganizationalUnitsValue
        : Option[List[OrganizationalUnit]] = scala
      .Option(impl.workspaceOrganizationalUnits())
      .map(value =>
        value.asScala.map { item =>
          item: OrganizationalUnit
        }.toList
      )
    override def workspaceRoleArnValue: Option[IamRoleArn] =
      scala.Option(impl.workspaceRoleArn()).map(value => value: IamRoleArn)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceRequest
  ): io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceRequest.ReadOnly =
    new Wrapper(impl)
}
