package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceAuthenticationResponse(
    authentication: io.github.vigoo.zioaws.grafana.model.AuthenticationDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse = {
    import UpdateWorkspaceAuthenticationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
      .builder()
      .authentication(authentication.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse
      .wrap(buildAwsValue())
}
object UpdateWorkspaceAuthenticationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse =
      io.github.vigoo.zioaws.grafana.model
        .UpdateWorkspaceAuthenticationResponse(authenticationValue.editable)
    def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly
    def authentication: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly
    ] = ZIO.succeed(authenticationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly {
    override def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.AuthenticationDescription
        .wrap(impl.authentication())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationResponse
  ): io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationResponse.ReadOnly =
    new Wrapper(impl)
}
