package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class UpdateWorkspaceAuthenticationRequest(
    authenticationProviders: Iterable[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ],
    samlConfiguration: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration
    ] = None,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest = {
    import UpdateWorkspaceAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
      .builder()
      .authenticationProvidersWithStrings(authenticationProviders.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(samlConfiguration.map(value => value.buildAwsValue()))(
        _.samlConfiguration
      )
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest
      .wrap(buildAwsValue())
}
object UpdateWorkspaceAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest =
      io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest(
        authenticationProvidersValue,
        samlConfigurationValue.map(value => value.editable),
        workspaceIdValue
      )
    def authenticationProvidersValue
        : List[io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes]
    def samlConfigurationValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ]
    def workspaceIdValue: WorkspaceId
    def authenticationProviders: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ]] = ZIO.succeed(authenticationProvidersValue)
    def samlConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("samlConfiguration", samlConfigurationValue)
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ) extends io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly {
    override def authenticationProvidersValue: List[
      io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
    ] = impl
      .authenticationProviders()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.AuthenticationProviderTypes
          .wrap(item)
      }
      .toList
    override def samlConfigurationValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ] = scala
      .Option(impl.samlConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.SamlConfiguration.wrap(value)
      )
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdateWorkspaceAuthenticationRequest
  ): io.github.vigoo.zioaws.grafana.model.UpdateWorkspaceAuthenticationRequest.ReadOnly =
    new Wrapper(impl)
}
