package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionsResponse(
    errors: Iterable[io.github.vigoo.zioaws.grafana.model.UpdateError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse = {
    import UpdatePermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse
      .wrap(buildAwsValue())
}
object UpdatePermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse =
      io.github.vigoo.zioaws.grafana.model
        .UpdatePermissionsResponse(errorsValue.map { item =>
          item.editable
        })
    def errorsValue
        : List[io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly]
    def errors: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly
    ]] = ZIO.succeed(errorsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ) extends io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly {
    override def errorsValue
        : List[io.github.vigoo.zioaws.grafana.model.UpdateError.ReadOnly] = impl
      .errors()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.grafana.model.UpdateError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.UpdatePermissionsResponse
  ): io.github.vigoo.zioaws.grafana.model.UpdatePermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
