package io.github.vigoo.zioaws.grafana.model
import scala.jdk.CollectionConverters.*
sealed trait UpdateAction {
  def unwrap: software.amazon.awssdk.services.grafana.model.UpdateAction
}
object UpdateAction {
  def wrap(
      value: software.amazon.awssdk.services.grafana.model.UpdateAction
  ): io.github.vigoo.zioaws.grafana.model.UpdateAction = value match {
    case software.amazon.awssdk.services.grafana.model.UpdateAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.grafana.model.UpdateAction.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.grafana.model.UpdateAction.REVOKE =>
      val r = REVOKE
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends io.github.vigoo.zioaws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.ADD
  }
  case object REVOKE extends io.github.vigoo.zioaws.grafana.model.UpdateAction {
    override def unwrap
        : software.amazon.awssdk.services.grafana.model.UpdateAction =
      software.amazon.awssdk.services.grafana.model.UpdateAction.REVOKE
  }
}
