package io.github.vigoo.zioaws.grafana.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  LoginValidityDuration,
  AllowedOrganization
}
import scala.jdk.CollectionConverters.*
final case class SamlConfiguration(
    allowedOrganizations: Option[Iterable[AllowedOrganization]] = None,
    assertionAttributes: Option[
      io.github.vigoo.zioaws.grafana.model.AssertionAttributes
    ] = None,
    idpMetadata: io.github.vigoo.zioaws.grafana.model.IdpMetadata,
    loginValidityDuration: Option[LoginValidityDuration] = None,
    roleValues: Option[io.github.vigoo.zioaws.grafana.model.RoleValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.SamlConfiguration = {
    import SamlConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
      .builder()
      .optionallyWith(
        allowedOrganizations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedOrganizations)
      .optionallyWith(assertionAttributes.map(value => value.buildAwsValue()))(
        _.assertionAttributes
      )
      .idpMetadata(idpMetadata.buildAwsValue())
      .optionallyWith(loginValidityDuration.map(value => value: Integer))(
        _.loginValidityDuration
      )
      .optionallyWith(roleValues.map(value => value.buildAwsValue()))(
        _.roleValues
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.SamlConfiguration.wrap(buildAwsValue())
}
object SamlConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.SamlConfiguration =
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration(
        allowedOrganizationsValue.map(value => value),
        assertionAttributesValue.map(value => value.editable),
        idpMetadataValue.editable,
        loginValidityDurationValue.map(value => value),
        roleValuesValue.map(value => value.editable)
      )
    def allowedOrganizationsValue: Option[List[AllowedOrganization]]
    def assertionAttributesValue: Option[
      io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly
    ]
    def idpMetadataValue
        : io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly
    def loginValidityDurationValue: Option[LoginValidityDuration]
    def roleValuesValue
        : Option[io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly]
    def allowedOrganizations: ZIO[Any, AwsError, List[AllowedOrganization]] =
      AwsError.unwrapOptionField(
        "allowedOrganizations",
        allowedOrganizationsValue
      )
    def assertionAttributes: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "assertionAttributes",
      assertionAttributesValue
    )
    def idpMetadata: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly
    ] = ZIO.succeed(idpMetadataValue)
    def loginValidityDuration: ZIO[Any, AwsError, LoginValidityDuration] =
      AwsError.unwrapOptionField(
        "loginValidityDuration",
        loginValidityDurationValue
      )
    def roleValues: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly
    ] = AwsError.unwrapOptionField("roleValues", roleValuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ) extends io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly {
    override def allowedOrganizationsValue: Option[List[AllowedOrganization]] =
      scala
        .Option(impl.allowedOrganizations())
        .map(value =>
          value.asScala.map { item =>
            item: AllowedOrganization
          }.toList
        )
    override def assertionAttributesValue: Option[
      io.github.vigoo.zioaws.grafana.model.AssertionAttributes.ReadOnly
    ] = scala
      .Option(impl.assertionAttributes())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.AssertionAttributes.wrap(value)
      )
    override def idpMetadataValue
        : io.github.vigoo.zioaws.grafana.model.IdpMetadata.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.IdpMetadata.wrap(impl.idpMetadata())
    override def loginValidityDurationValue: Option[LoginValidityDuration] =
      scala
        .Option(impl.loginValidityDuration())
        .map(value => value: LoginValidityDuration)
    override def roleValuesValue
        : Option[io.github.vigoo.zioaws.grafana.model.RoleValues.ReadOnly] =
      scala
        .Option(impl.roleValues())
        .map(value =>
          io.github.vigoo.zioaws.grafana.model.RoleValues.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.SamlConfiguration
  ): io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly =
    new Wrapper(impl)
}
