package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SamlAuthentication(
    configuration: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration
    ] = None,
    status: io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.SamlAuthentication = {
    import SamlAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.SamlAuthentication
      .builder()
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.SamlAuthentication
      .wrap(buildAwsValue())
}
object SamlAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.SamlAuthentication =
      io.github.vigoo.zioaws.grafana.model.SamlAuthentication(
        configurationValue.map(value => value.editable),
        statusValue
      )
    def configurationValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ]
    def statusValue
        : io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
    def configuration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configurationValue)
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ) extends io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly {
    override def configurationValue: Option[
      io.github.vigoo.zioaws.grafana.model.SamlConfiguration.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        io.github.vigoo.zioaws.grafana.model.SamlConfiguration.wrap(value)
      )
    override def statusValue
        : io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus =
      io.github.vigoo.zioaws.grafana.model.SamlConfigurationStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.SamlAuthentication
  ): io.github.vigoo.zioaws.grafana.model.SamlAuthentication.ReadOnly =
    new Wrapper(impl)
}
