package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PermissionEntry(
    role: io.github.vigoo.zioaws.grafana.model.Role,
    user: io.github.vigoo.zioaws.grafana.model.User
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.PermissionEntry = {
    import PermissionEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.PermissionEntry
      .builder()
      .role(role.unwrap)
      .user(user.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.PermissionEntry.wrap(buildAwsValue())
}
object PermissionEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.PermissionEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.PermissionEntry =
      io.github.vigoo.zioaws.grafana.model
        .PermissionEntry(roleValue, userValue.editable)
    def roleValue: io.github.vigoo.zioaws.grafana.model.Role
    def userValue: io.github.vigoo.zioaws.grafana.model.User.ReadOnly
    def role: ZIO[Any, Nothing, io.github.vigoo.zioaws.grafana.model.Role] =
      ZIO.succeed(roleValue)
    def user: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.User.ReadOnly
    ] = ZIO.succeed(userValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.PermissionEntry
  ) extends io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly {
    override def roleValue: io.github.vigoo.zioaws.grafana.model.Role =
      io.github.vigoo.zioaws.grafana.model.Role.wrap(impl.role())
    override def userValue: io.github.vigoo.zioaws.grafana.model.User.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.User.wrap(impl.user())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.PermissionEntry
  ): io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly =
    new Wrapper(impl)
}
