package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListWorkspacesResponse(
    nextToken: Option[PaginationToken] = None,
    workspaces: Iterable[io.github.vigoo.zioaws.grafana.model.WorkspaceSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse = {
    import ListWorkspacesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .workspaces(workspaces.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse
      .wrap(buildAwsValue())
}
object ListWorkspacesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse =
      io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse(
        nextTokenValue.map(value => value),
        workspacesValue.map { item =>
          item.editable
        }
      )
    def nextTokenValue: Option[PaginationToken]
    def workspacesValue
        : List[io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly]
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def workspaces: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly
    ]] = ZIO.succeed(workspacesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ) extends io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse.ReadOnly {
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def workspacesValue
        : List[io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.ReadOnly] =
      impl
        .workspaces()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.grafana.model.WorkspaceSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesResponse
  ): io.github.vigoo.zioaws.grafana.model.ListWorkspacesResponse.ReadOnly =
    new Wrapper(impl)
}
