package io.github.vigoo.zioaws.grafana.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  PaginationToken,
  ListWorkspacesRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListWorkspacesRequest(
    maxResults: Option[ListWorkspacesRequestMaxResultsInteger] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest = {
    import ListWorkspacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest
      .wrap(buildAwsValue())
}
object ListWorkspacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest =
      io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest(
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value)
      )
    def maxResultsValue: Option[ListWorkspacesRequestMaxResultsInteger]
    def nextTokenValue: Option[PaginationToken]
    def maxResults: ZIO[Any, AwsError, ListWorkspacesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ) extends io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest.ReadOnly {
    override def maxResultsValue
        : Option[ListWorkspacesRequestMaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value => value: ListWorkspacesRequestMaxResultsInteger)
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListWorkspacesRequest
  ): io.github.vigoo.zioaws.grafana.model.ListWorkspacesRequest.ReadOnly =
    new Wrapper(impl)
}
