package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListPermissionsResponse(
    nextToken: Option[PaginationToken] = None,
    permissions: Iterable[io.github.vigoo.zioaws.grafana.model.PermissionEntry]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListPermissionsResponse = {
    import ListPermissionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .permissions(permissions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse
      .wrap(buildAwsValue())
}
object ListPermissionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse =
      io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse(
        nextTokenValue.map(value => value),
        permissionsValue.map { item =>
          item.editable
        }
      )
    def nextTokenValue: Option[PaginationToken]
    def permissionsValue
        : List[io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly]
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def permissions: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly
    ]] = ZIO.succeed(permissionsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ) extends io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse.ReadOnly {
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def permissionsValue
        : List[io.github.vigoo.zioaws.grafana.model.PermissionEntry.ReadOnly] =
      impl
        .permissions()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.grafana.model.PermissionEntry.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsResponse
  ): io.github.vigoo.zioaws.grafana.model.ListPermissionsResponse.ReadOnly =
    new Wrapper(impl)
}
