package io.github.vigoo.zioaws.grafana.model
import java.lang.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import io.github.vigoo.zioaws.grafana.model.primitives.{
  WorkspaceId,
  PaginationToken,
  ListPermissionsRequestMaxResultsInteger,
  SsoId
}
import scala.jdk.CollectionConverters.*
final case class ListPermissionsRequest(
    groupId: Option[SsoId] = None,
    maxResults: Option[ListPermissionsRequestMaxResultsInteger] = None,
    nextToken: Option[PaginationToken] = None,
    userId: Option[SsoId] = None,
    userType: Option[io.github.vigoo.zioaws.grafana.model.UserType] = None,
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.ListPermissionsRequest = {
    import ListPermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
      .builder()
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest
      .wrap(buildAwsValue())
}
object ListPermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest =
      io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest(
        groupIdValue.map(value => value),
        maxResultsValue.map(value => value),
        nextTokenValue.map(value => value),
        userIdValue.map(value => value),
        userTypeValue.map(value => value),
        workspaceIdValue
      )
    def groupIdValue: Option[SsoId]
    def maxResultsValue: Option[ListPermissionsRequestMaxResultsInteger]
    def nextTokenValue: Option[PaginationToken]
    def userIdValue: Option[SsoId]
    def userTypeValue: Option[io.github.vigoo.zioaws.grafana.model.UserType]
    def workspaceIdValue: WorkspaceId
    def groupId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("groupId", groupIdValue)
    def maxResults
        : ZIO[Any, AwsError, ListPermissionsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def userId: ZIO[Any, AwsError, SsoId] =
      AwsError.unwrapOptionField("userId", userIdValue)
    def userType
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.grafana.model.UserType] =
      AwsError.unwrapOptionField("userType", userTypeValue)
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ) extends io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest.ReadOnly {
    override def groupIdValue: Option[SsoId] =
      scala.Option(impl.groupId()).map(value => value: SsoId)
    override def maxResultsValue
        : Option[ListPermissionsRequestMaxResultsInteger] = scala
      .Option(impl.maxResults())
      .map(value => value: ListPermissionsRequestMaxResultsInteger)
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def userIdValue: Option[SsoId] =
      scala.Option(impl.userId()).map(value => value: SsoId)
    override def userTypeValue
        : Option[io.github.vigoo.zioaws.grafana.model.UserType] = scala
      .Option(impl.userType())
      .map(value => io.github.vigoo.zioaws.grafana.model.UserType.wrap(value))
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.ListPermissionsRequest
  ): io.github.vigoo.zioaws.grafana.model.ListPermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
