package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceResponse(
    workspace: io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse = {
    import DescribeWorkspaceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
      .builder()
      .workspace(workspace.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse =
      io.github.vigoo.zioaws.grafana.model
        .DescribeWorkspaceResponse(workspaceValue.editable)
    def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    def workspace: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly
    ] = ZIO.succeed(workspaceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ) extends io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly {
    override def workspaceValue
        : io.github.vigoo.zioaws.grafana.model.WorkspaceDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.WorkspaceDescription
        .wrap(impl.workspace())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceResponse
  ): io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceResponse.ReadOnly =
    new Wrapper(impl)
}
