package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceRequest(workspaceId: WorkspaceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest = {
    import DescribeWorkspaceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
      .builder()
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceRequest =
      io.github.vigoo.zioaws.grafana.model
        .DescribeWorkspaceRequest(workspaceIdValue)
    def workspaceIdValue: WorkspaceId
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ) extends io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceRequest.ReadOnly {
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceRequest
  ): io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceRequest.ReadOnly =
    new Wrapper(impl)
}
