package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceAuthenticationResponse(
    authentication: io.github.vigoo.zioaws.grafana.model.AuthenticationDescription
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse = {
    import DescribeWorkspaceAuthenticationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
      .builder()
      .authentication(authentication.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse
      .wrap(buildAwsValue())
}
object DescribeWorkspaceAuthenticationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse =
      io.github.vigoo.zioaws.grafana.model
        .DescribeWorkspaceAuthenticationResponse(authenticationValue.editable)
    def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly
    def authentication: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly
    ] = ZIO.succeed(authenticationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ) extends io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly {
    override def authenticationValue
        : io.github.vigoo.zioaws.grafana.model.AuthenticationDescription.ReadOnly =
      io.github.vigoo.zioaws.grafana.model.AuthenticationDescription
        .wrap(impl.authentication())
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationResponse
  ): io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationResponse.ReadOnly =
    new Wrapper(impl)
}
