package io.github.vigoo.zioaws.grafana.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import io.github.vigoo.zioaws.grafana.model.primitives.WorkspaceId
import scala.jdk.CollectionConverters.*
final case class DescribeWorkspaceAuthenticationRequest(
    workspaceId: WorkspaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest = {
    import DescribeWorkspaceAuthenticationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
      .builder()
      .workspaceId(workspaceId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly =
    io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationRequest
      .wrap(buildAwsValue())
}
object DescribeWorkspaceAuthenticationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationRequest =
      io.github.vigoo.zioaws.grafana.model
        .DescribeWorkspaceAuthenticationRequest(workspaceIdValue)
    def workspaceIdValue: WorkspaceId
    def workspaceId: ZIO[Any, Nothing, WorkspaceId] =
      ZIO.succeed(workspaceIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ) extends io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly {
    override def workspaceIdValue: WorkspaceId = impl.workspaceId(): WorkspaceId
  }
  def wrap(
      impl: software.amazon.awssdk.services.grafana.model.DescribeWorkspaceAuthenticationRequest
  ): io.github.vigoo.zioaws.grafana.model.DescribeWorkspaceAuthenticationRequest.ReadOnly =
    new Wrapper(impl)
}
